/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.djl;

import javafx.scene.control.Menu;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.djl.DjlDnnModel;
import qupath.ext.djl.DjlDnnModelBuilder;
import qupath.ext.djl.ui.DjlEngineCommand;
import qupath.ext.djl.ui.LaunchScriptCommand;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.extensions.GitHubProject;
import qupath.lib.gui.extensions.QuPathExtension;
import qupath.lib.gui.tools.MenuTools;
import qupath.opencv.dnn.DnnModelBuilder;
import qupath.opencv.dnn.DnnModels;

public class DjlExtension
implements QuPathExtension,
GitHubProject {
    private static final Logger logger = LoggerFactory.getLogger(DjlExtension.class);
    private static final DnnModelBuilder builder = new DjlDnnModelBuilder();

    public void installExtension(QuPathGUI qupath) {
        if (Version.COMPARATOR_MAJOR_MINOR_PATCH.compare(QuPathGUI.getVersion(), this.getQuPathVersion()) < 0) {
            throw new UnsupportedOperationException("This extension version is incompatible with QuPath < v" + String.valueOf(this.getQuPathVersion()));
        }
        logger.debug("Installing Deep Java Library extension");
        logger.info("Registering DjlDnnModel");
        DnnModels.registerDnnModel(DjlDnnModel.class, (String)DjlDnnModel.class.getSimpleName());
        DnnModels.registerBuilder((DnnModelBuilder)builder);
        Menu menu = qupath.getMenu("Extensions>Deep Java Library", true);
        MenuTools.addMenuItems((Menu)menu, (Object[])new Object[]{new Action("Manage DJL engines", e -> DjlEngineCommand.showDialog(qupath))});
        LaunchScriptCommand cmd = new LaunchScriptCommand();
        Action action = new Action("Create launch script", e -> cmd.promptForScript());
        MenuTools.addMenuItems((Menu)menu, (Object[])new Object[]{action});
    }

    public String getName() {
        return "Deep Java Library extension";
    }

    public String getDescription() {
        return "Add Deep Java Library support to QuPath";
    }

    public GitHubProject.GitHubRepo getRepository() {
        return GitHubProject.GitHubRepo.create((String)this.getName(), (String)"qupath", (String)"qupath-extension-djl");
    }

    public Version getQuPathVersion() {
        return Version.parse((String)"0.6.0");
    }

    static {
        System.setProperty("ai.djl.offline", "true");
        System.setProperty("OPT_OUT_TRACKING", "true");
    }
}

